import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../../utils/auth'
import { ImageUploader } from '../../../utils/uploaders'
const router = Router()

router.get('/', validations.getRewards, auth.authorizeAdmin, controllers.getRewards)

router.get('/:id', validations.getReward, auth.authorizeAdmin, controllers.getReward)

router.post('/', ImageUploader.single('cover'), validations.postReward, auth.authorizeAdmin, controllers.postReward)

router.delete('/:id', validations.getReward, auth.authorizeAdmin, controllers.deleteReward)

module.exports = router
