import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function getRewards(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			limit: 'optional|string|natural',
			page: 'optional|string|natural',
			search: 'optional|string',
			isMeetme: 'optional|string|boolean',
			isActive: 'optional|string|boolean'
		}
		const { errors } = validate(rules, req.query)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function getReward(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			id: 'mongoid'
		}

		const { errors } = validate(rules, req.params)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postReward(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			title: 'string|min:1|max:30',
			description: 'string|min:5|max:200',
			total: 'string|natural',
			locationString: 'optional|string|min:3|max:100',
			latitude: 'optional|string|number|min:-90|max:90',
			longitude: 'optional|string|number|min:-180|max:180',
			isMeetme: 'optional|string|boolean',
			coupon: 'optional|string',
			expiredAt: 'optional|datetime'
		}

		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	getRewards,
	getReward,
	postReward
}

export default validations
