import { Schema, model, Document, Types } from 'mongoose'
import { ILocation, LocationSchema } from '../../utils/types'

const RewardSchema = new Schema(
	{
		title: {
			type: String,
			required: true
		},
		description: {
			type: String,
			required: true
		},
		cover: {
			type: String,
			required: true
		},
		total: {
			type: Number,
			required: true
		},
		remaining: {
			type: Number,
			required: true
		},
		coupon: String,
		isMeetme: Boolean,
		location: LocationSchema,
		locationString: String,
		expiredAt: Date
	},
	{ versionKey: false, timestamps: true }
)

RewardSchema.index({ location: '2dsphere' })

export interface IReward extends Document {
	_id: Types.ObjectId
	title: string
	description: string
	cover: string
	total: number
	remaining: number
	coupon?: string
	isMeetme?: boolean
	location?: ILocation
	locationString?: string
	expiredAt?: Date
	createdAt: Date
	updatedAt: Date
}

export const Reward = model('Reward', RewardSchema, 'rewards')
