import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/meetme', validations.getMeetmeRewards, auth.authorizeUser, controllers.getMeetmeRewards)

router.get('/profile', auth.authorizeUser, controllers.getProfileRewards)

router.post('/:id/generate-hash', validations.postGenerateRewardHash, auth.authorizeUser, controllers.postGenerateRewardHash)

router.post('/opened-view-all', auth.authorizeUser, controllers.postOpenedViewAll)

module.exports = router
