import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function getMeetmeRewards(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			limit: 'optional|string|natural',
			page: 'optional|string|natural',
		}
		const { errors } = validate(rules, req.query)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postGenerateRewardHash(req: Request, res: Response, next: NextFunction) {
	try {
		const { errors } = validate({id: 'mongoid'}, req.params)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	getMeetmeRewards,
	postGenerateRewardHash
}

export default validations
