import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getScores, auth.authorizeUser, controllers.getScores)

router.get('/today', auth.authorizeUser, controllers.getTodayScore)

router.post('/journal', validations.postScoreJournal, auth.authorizeUser, controllers.postScoreJournal)

module.exports = router
