import { Schema, model, Document, Types } from 'mongoose'

const ShareSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		chats: {
			type: [Types.ObjectId],
			default: undefined
		},
		count: {
			type: Number,
			default: 1,
		},
		reel: {
			type: Types.ObjectId,
      ref: 'Reel',
			required: true,
		},
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface IShare extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	reel: Types.ObjectId
	at: Date
}

export const Share = model('Share', ShareSchema, 'shares')
