import { Schema, model, Document, Types } from 'mongoose'
import { ILocation, LocationSchema } from '../../utils/types'

const StatusSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		categories: {
			type: [String],
			required: true,
		},
		schedule: {
			type: String,
			enum: ['now', 'later'],
			required: true,
		},
		startDateType: {
			type: String,
			enum: ['today', 'tomorrow', 'custom'],
			required: true,
		},
		startDate: {
			type: String,
			required: true,
		},
		startTime: {
			type: String,
			required: true,
		},
		title: String,
		startedAt: {
			type: Date,
			required: true
		},
		visibleAt: {
			type: Date,
			required: true
		},
		endedAt: {
			type: Date,
			required: true
		},
		location: LocationSchema,
		locationString: String,
	},
	{ versionKey: false, timestamps: true }
)

StatusSchema.index({ location: '2dsphere' })

export interface IStatus extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	categories: string[]
	title: string
	schedule: 'now' | 'later'
	startDateType: 'today' | 'tomorrow' | 'custom'
	startDate: string  // YYYY-MM-DD
	startTime: string  // 11:45 PM
	startedAt: Date
	visibleAt: Date
	endedAt: Date
	location?: ILocation
	locationString?: string
	createdAt: Date
	updatedAt: Date
}

export const Status = model('Status', StatusSchema, 'statuses')
