import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getStatuses, auth.authorizeUser, controllers.getStatuses)

router.get('/search', validations.getStatusesAndEvents, auth.authorizeUser, controllers.getStatusesAndEvents)

router.post('/', validations.postStatus, auth.authorizeUser, controllers.postStatus)

router.patch('/', validations.patchStatus, auth.authorizeUser, controllers.patchStatus)

router.delete('/', auth.authorizeUser, controllers.deleteStatus)

module.exports = router
