[Goto Home](/docs/index.html)

# 🔒 GET `/statuses`

## Description

- Returns the list of matching statuses of different users
- Don't return the current user status
- Returns only those status which either:
  - don't have any location field
  - which exist under 10km radius
- If user don't have any location field, then location filter would be disabled
- Update `search-with-meetme-category-filter` action of vibe social score of that user and send socket notification with event `score-updated`

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **search** - apply search filter for user based on user name
- **categories** - sets the categories filter for statuses, must be comma separated, e.g. `Gym,Open for Anything`

## Response Body

```json
{
  "users": [
    {
      "_id": "68914287e4c3076d9436523c",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-04T23:30:15.820Z",
      "updatedAt": "2025-08-13T06:42:16.502Z",
      "name": "Amy Jackson",
      "username": "amy.jackson",
      "bio": "I am a song lover",
      "status": {
        "_id": "689c33c805d06cb919e301d3",
        "user": "68914287e4c3076d9436523c",
        "categories": ["Open for Anything"],
        "schedule": "now",
        "startDateType": "today",
        "startDate": "2025-08-13",
        "startTime": "12:11 PM",
        "title": "Meet me at coffee",
        "startedAt": "2025-08-13T06:41:00.000Z",
        "visibleAt": "2025-08-12T18:41:00.000Z",
        "endedAt": "2025-08-13T07:41:00.000Z",
        "createdAt": "2025-08-13T06:42:16.092Z",
        "updatedAt": "2025-08-13T06:42:16.092Z",
        "location": {
          "type": "Point",
          "coordinates": [
            -34.566,
            12.455
          ]
        },
        "locationString": "Central Park, Rock-port, UK",
      },
      "connection": {
        "_id": "689c346d05d06cb919e301e9",
        "from": "688c51572b675be4b88339d1",
        "to": "68914287e4c3076d9436523c",
        "status": "accepted",
        "createdAt": "2025-08-13T06:45:01.000Z",
        "acceptedAt": "2025-08-13T06:46:49.541Z"
      }
    }
  ],
  "count": 1
}
```

# 🔒 GET `/statuses/search` - Meet Me search

## Description

- Returns the matching user statuses and events nearby
- Don't return the current user status

## Request Query

- **limit** - default `5`, set the number of items to return on each page
- **search** - required field; apply search filter for user based on its name, username & status title and for events - title and description; Minimum character required is `3`

## Response Body

```json
{
  "users": [
    {
      "_id": "688c51572b675be4b88339d1",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-01T05:32:07.075Z",
      "updatedAt": "2025-10-22T05:47:40.556Z",
      "name": "John Doe",
      "username": "john.doe",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
      "bio": "I am a workaholic",
      "status": {
        "_id": "68f86ffc6fd2628adeee4534",
        "user": "688c51572b675be4b88339d1",
        "categories": ["exam"],
        "schedule": "later",
        "startDateType": "today",
        "startDate": "2025-10-22",
        "startTime": "09:59 PM",
        "title": "Hi let's connect for exam preparation",
        "startedAt": "2025-10-22T16:29:00.000Z",
        "visibleAt": "2025-10-22T04:29:00.000Z",
        "endedAt": "2025-10-22T17:29:00.000Z",
        "location": {
          "type": "Point",
          "coordinates": [
            -34.566,
            12.455
          ]
        },
        "locationString": "Central Park, Rock-port, UK",
        "createdAt": "2025-10-22T05:47:40.146Z",
        "updatedAt": "2025-10-22T05:47:40.146Z"
      },
      "connection": {
        "_id": "689c346d05d06cb919e301e9",
        "from": "688c51572b675be4b88339d1",
        "to": "68914287e4c3076d9436523c",
        "status": "accepted",
        "createdAt": "2025-08-13T06:45:01.000Z",
        "acceptedAt": "2025-08-13T06:46:49.541Z"
      }
    }
  ],
  "events": [
    {
      "_id": "68eca782eab58ae34d040489",
      "user": "68c7f963d4ec4fd41b3e804b",
      "title": "Let's Plant Many Trees",
      "description": "Lets meet at this sunday, plant many trees and make our nature healthy",
      "date": "2025-11-12",
      "time": "11:00 AM",
      "location": {
        "type": "Point",
        "coordinates": [
          -71.0948037,
          42.360092
        ]
      },
      "locationString": "77 Massachusetts Ave, Cambridge, MA 02139, United States",
      "chat": {
        "_id": "68eca782eab58ae34d040487",
        "creator": "68c7f963d4ec4fd41b3e804b",
        "isGroup": true,
        "name": "Let's Plant Many Trees",
        "allowPublicPost": true,
        "areYouAdmin": true,
        "tags": [],
        "participants": [
          {
            "user": "68c7f963d4ec4fd41b3e804b",
            "isAdmin": true,
            "_id": "68eca782eab58ae34d040488",
            "lastReadAt": "2025-10-13T07:17:22.000Z"
          },
          {
            "user": "68ac3f6dd7f5a437029aa88f",
            "_id": "68ef6dd1b774b6019cf94617",
            "lastReadAt": "2025-10-21T08:34:27.073Z"
          }
        ],
        "event": "68eca782eab58ae34d040489",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68eca782eab58ae34d040487/1760339841971-1786227063776834-tree.png",
        "createdAt": "2025-10-13T07:17:25.793Z",
        "updatedAt": "2025-10-21T08:34:27.074Z",
        "lastMessage": "68f35a006ce2864d871fbba9",
        "participantsCount": 2,
        "isJoined": false
      },
      "categories": ["Plants"],
      "startedAt": "2025-11-12T05:30:00.000Z",
      "endedAt": "2025-11-12T10:30:00.000Z",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68eca782eab58ae34d040487/1760339841971-1786227063776834-tree.png",
      "createdAt": "2025-10-13T07:17:26.118Z",
      "updatedAt": "2025-10-13T07:17:26.118Z",
      "joined": false
    }
  ]
}
```

# 🔒 POST `/statuses`

## Description

- Creates a new status
- Either previous status should not exist or it must expire
- A user can have only 1 status at a time
- If previous status is ended, then it will delete it
- If location is not given, then it uses user's location by default
- Update `create-meetme-status` action of vibe social score of that user and send socket notification with event `score-updated`

## Request Body

```ts
{
  categories: ['Open for Anything'],
  schedule: 'now' | 'later',
  startDateType: 'today' | 'tomorrow' | 'custom'
  startDate: '2025-10-30',  // YYYY-MM-DD
  startTime: '11:45 PM',    // hh:mm AM/PM
  title: 'Meet me at Coffee',  // can be empty string
  latitude?: 12.455,
  longitude?: -34.566,
  locationString?: 'Central Park, Rock-port, UK',
}
```

## Response Body

```json
{
  "status": {
    "user": "688c51572b675be4b88339d1",
    "categories": ["Open for Anything"],
    "schedule": "now",
    "startDateType": "today",
    "startDate": "2025-10-30",
    "startTime": "11:45 PM",
    "title": "Meet me at coffee",
    "startedAt": "2025-10-30T18:15:00.000Z",
    "visibleAt": "2025-10-30T06:15:00.000Z",
    "endedAt": "2025-10-30T19:15:00.000Z",
    "_id": "6899b380c5c8fc296952e6f0",
    "createdAt": "2025-08-11T09:10:24.265Z",
    "updatedAt": "2025-08-11T09:10:24.265Z",
    "location": {
      "type": "Point",
      "coordinates": [
        -34.566,
        12.455
      ]
    },
    "locationString": "Central Park, Rock-port, UK",
  }
}
```

# 🔒 PATCH `/statuses`

## Description

- Update the current status if exist
- A status must exist

## Request Body

```ts
{
  categories?: ['Open for anything'],
  schedule?: 'now' | 'later',
  startDateType?: 'today' | 'tomorrow' | 'custom',
  startDate?: '2025-10-30',  // YYYY-MM-DD
  startTime?: '11:45 PM',    // hh:mm AM/PM
  title?: 'Meet me at Coffee',  // can be empty string
  latitude?: 12.455,
  longitude?: -34.566,
  locationString?: 'Central Park, Rock-port, UK',
}
```

## Response Body

```json
{
  "status": {
    "user": "688c51572b675be4b88339d1",
    "categories": ["Open for Anything"],
    "schedule": "now",
    "startDateType": "today",
    "startDate": "2025-10-30",
    "startTime": "11:45 PM",
    "title": "Meet me at coffee",
    "startedAt": "2025-10-30T18:15:00.000Z",
    "visibleAt": "2025-10-30T06:15:00.000Z",
    "endedAt": "2025-10-30T19:15:00.000Z",
    "_id": "6899b380c5c8fc296952e6f0",
    "location": {
      "type": "Point",
      "coordinates": [
        -34.566,
        12.455
      ]
    },
    "locationString": "Central Park, Rock-port, UK",
    "createdAt": "2025-08-11T09:10:24.265Z",
    "updatedAt": "2025-08-11T09:10:24.265Z"
  }
}
```

# 🔒 DELETE `/statuses`

## Description

- Delete the current status
- A status must exist

# Links

[Goto Home](/docs/index.html)