import { Schema, model, Document, Types } from 'mongoose'

const SuperLikeSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		reel: {
			type: Types.ObjectId,
      ref: 'Reel',
			required: true
		},
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface ISuperLike extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	reel: Types.ObjectId
	at: Date
}

export const SuperLike = model('SuperLike', SuperLikeSchema, 'super-likes')
