import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.post('/:reelId', validations.checkSuperLike, auth.authorizeUser, controllers.postSuperLike)

router.delete('/:reelId', validations.checkSuperLike, auth.authorizeUser, controllers.deleteSuperLike)

module.exports = router
