import { Schema, model, Document, Types } from 'mongoose'

const UsageSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true
		},
		reel: {
			type: Types.ObjectId,
      ref: 'Reel'
		},
		seconds: {
			type: String,
			required: true
		},
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface IUsage extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	reel?: Types.ObjectId
	seconds: number
  at: Date
}

export const Usage = model('Usage', UsageSchema, 'usages')
