import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function postUsage(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			reel: 'optional|mongoid',
			seconds: 'positive'
		}

		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	postUsage
}

export default validations
