import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../../utils/auth'
const router = Router()

router.get('/', validations.getUsers, auth.authorizeAdmin, controllers.getUsers)

router.get('/:id', validations.getUser, auth.authorizeAdmin, controllers.getUser)

router.patch('/:id', validations.patchUser, auth.authorizeAdmin, controllers.patchUser)

router.delete('/:id', validations.deleteUser, auth.authorizeAdmin, controllers.deleteUser)

module.exports = router
