import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function getUsers(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			limit: 'optional|string|natural',
			page: 'optional|string|natural',
			search: 'optional|string',
			emailVerified: 'optional|string|boolean',
			phoneVerified: 'optional|string|boolean',
			terminated: 'optional|string|boolean',
			'2fa': 'optional|string|boolean',
			verified: 'optional|string|boolean',
		}
		const { errors } = validate(rules, req.query)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function getUser(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			id: 'mongoid'
		}

		const { errors } = validate(rules, req.params)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function patchUser(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			id: 'mongoid',
			verified: 'optional|boolean'
		}

		const { errors } = validate(rules, {...req.params, ...req.body})
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function deleteUser(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			id: 'mongoid'
		}

		const { errors } = validate(rules, req.params)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	getUsers,
	getUser,
	patchUser,
	deleteUser
}

export default validations
