import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import { ImageUploader } from '../../utils/uploaders'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getUsers, auth.authorizeUser, controllers.getUsers)

router.get('/explore', validations.getExploreUsersAndChats, auth.authorizeUser, controllers.getExploreUsersAndChats)

router.get('/meetme/online-users', validations.getMeetmeOnlineUsers, auth.authorizeUser, controllers.getMeetmeOnlineUsers)

router.get('/profile', auth.authorizeUser, controllers.getProfile)

router.get('/:id', auth.authorizeUser, controllers.getUser)

router.patch('/', validations.patchUser, auth.authorizeUser, controllers.patchUser)

router.post('/check-username', validations.postCheckUsername, auth.authorizeUser, controllers.postCheckUsername)

router.put(
	'/photo',
	ImageUploader.single('photo'),
	validations.putProfilePhoto,
	auth.authorizeUser,
	controllers.putProfilePhoto
)

router.delete(
	'/me',
	auth.authorizeUser,
	controllers.deleteUser
)

module.exports = router
