[Goto Home](/docs/index.html)

# 🔒 GET `/users`

## Description

- Returns the list of matching users
- Don't return the current user

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **search** - apply search filter for user based on its name and username
- **categories** - sets the categories filter for users, must be comma separated, e.g. `Study Tips,Music,Habits & Routines`

## Response Body

```json
{
  "users": [
    {
      "_id": "68914287e4c3076d9436523c",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-04T23:30:15.820Z",
      "updatedAt": "2025-08-04T23:34:12.134Z",
      "bio": "I am a song lover",
      "name": "Amy Jackson",
      "username": "amy.jackson",
      "verified": true,
      "connection": {
        "_id": "689c346d05d06cb919e301e9",
        "from": "688c51572b675be4b88339d1",
        "to": "68914287e4c3076d9436523c",
        "status": "accepted",
        "createdAt": "2025-08-13T06:45:01.000Z",
        "acceptedAt": "2025-08-13T06:46:49.541Z"
      }
    },
    {
      "_id": "68906b08a3bf95fd187f7a22",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-04T08:10:48.716Z",
      "updatedAt": "2025-08-04T08:50:14.880Z",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754295084077-4594504751191403-1754295082202-93b5ff98-7f0f-4a17-b5ae-f7ca5152d7d4.jpeg.jpg",
      "name": "Jassi Singh",
      "username": "mr_scanner",
      "verified": true,
    }
  ],
  "count": 2
}
```

# 🔒 GET `/users/explore` - Explore search

## Description

- Returns the matching users and group chats
- Don't return the current user

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **search** - required field; apply search filter for user based on its name and username and for chats name; Minimum character required is `3`

## Response Body

```json
{
  "users": [
    {
      "_id": "68ac3f6dd7f5a437029aa88f",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-25T10:48:13.368Z",
      "updatedAt": "2025-10-14T09:16:01.065Z",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1758007790332-16697659211217097-1758007788161-f05c235e-a4de-4519-8615-ed9802295e9d.jpeg.jpg",
      "name": "Jass Singh",
      "username": "bat_ma_n",
      "bio": "New Bio +1",
      "verified": true
    }
  ],
  "chats": [
    {
      "_id": "68ee530a808e28d0b11beec9",
      "isGroup": true,
      "name": "Pool Party",
      "allowPublicPost": true,
      "areYouAdmin": true,
      "participants": [
        {
          "user": "68914287e4c3076d9436523c",
          "isAdmin": true,
          "_id": "68ee530a808e28d0b11beeca",
          "lastReadAt": "2025-10-24T11:23:59.609Z"
        },
        {
          "user": "688c51572b675be4b88339d1",
          "_id": "68f8b97793ecb98e6261a6eb",
          "lastReadAt": "2025-10-22T11:23:18.751Z"
        }
      ],
      "event": "68ee530a808e28d0b11beecb",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68ee530a808e28d0b11beec9/1760449289304-22034956871186895-tree.png",
      "createdAt": "2025-10-14T13:41:32.673Z",
      "updatedAt": "2025-10-24T11:23:59.610Z",
      "restricted": true,
      "request": {
        "_id": "68fb2194ebd831054c0411cc",
        "user": "689b1fca132cd7d169e76e2d",
        "chat": "68ee530a808e28d0b11beec9",
        "status": "pending",
        "createdAt": "2025-10-24T06:49:56.000Z"
      },
      "participantsCount": 2,
      "isJoined": false
    }
  ]
}
```

# 🔒 GET `/users/meetme/online-users`

## Description

- Returns the list of mutual users which are online
- Don't return the current user
- Add location filter
- Also populate the one-to-one chat data, if exist

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items

## Response Body

```json
{
  "users": [
    {
      "_id": "68ac3f6dd7f5a437029aa88f",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1760618979709-3310522348281584-1760618978233-543e7038-2cf6-46b9-ac0d-9af0cb741d6b.jpeg.jpg",
      "name": "Scanner",
      "username": "bat_ma_n",
      "lastOnlineAt": "2025-11-25T09:04:55.939Z",
      "isOnline": true,
      "chat": {
        "_id": "68c7fdabd4ec4fd41b3e83bf",
        "creator": "688c51572b675be4b88339d1",
        "user": "68ac3f6dd7f5a437029aa88f",
        "participants": [
          {
            "user": "688c51572b675be4b88339d1",
            "_id": "68c7fdabd4ec4fd41b3e83c0",
            "lastReadAt": "2025-11-19T11:29:05.640Z",
            "isAdmin": true
          },
          {
            "user": "68ac3f6dd7f5a437029aa88f",
            "_id": "68c7fdabd4ec4fd41b3e83c1",
            "lastReadAt": "2025-11-24T07:40:27.218Z"
          }
        ],
        "createdAt": "2025-09-15T11:51:07.505Z",
        "updatedAt": "2025-11-24T07:40:27.219Z",
        "lastMessage": "6923f6f09a372b336e161b52",
        "tags": [
          {
            "tag": "exams",
            "label": "Exams"
          },
          {
            "tag": "lectures",
            "label": "Lectures & Summaries"
          }
        ],
        "allowPublicPost": true
      }
    },
    {
      "_id": "68c7f963d4ec4fd41b3e804b",
      "name": "Max_R",
      "username": "Max123_ABC",
      "lastOnlineAt": "2025-11-25T08:50:58.617Z",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg"
    }
  ],
  "count": 2
}
```

# 🔒 GET `/users/profile`

## Description

- Returns the details of the current user
- Also populate `isSuperLikeAvailable`

## Response Body

```json
{
  "user": {
    "_id": "688c51572b675be4b88339d1",
    "email": "john.doe@example.com",
    "dob": "1997-01-23T00:00:00.000Z",
    "auth": {
      "phoneVerified": false,
      "emailVerified": true
    },
    "verified": true,
    "createdAt": "2025-08-01T05:32:07.075Z",
    "updatedAt": "2025-08-01T10:16:32.692Z",
    "purposes": [
      {
        "type": "short-term",
        "value": [
          "Improve mental wellness",
          "Grow meaningful relationships"
        ]
      },
      {
        "type": "long-term",
        "value": [
          "Improve mental wellness",
          "Enhance academic success"
        ]
      }
    ],
    "name": "John Doe",
    "phone": "+1 1234567899",
    "username": "john.doe",
    "bio": "I am a workaholic 😎",
    "url": "https://instagram.com/john.doe",
    "school": "Computer Science & Human Centered Design",
    "courses": "Algorithms, Designs, Robotics, Ethics",
    "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
    "isSuperLikeAvailable": true,
    "studies": [
      {
        "type": "Engineering",
        "value": [
          "Mechanical Engineering",
          "Robotics Engineering"
        ]
      },
      {
        "type": "Business & Management",
        "value": [
          "Financial Accounting",
          "Marketing 101"
        ]
      },
      {
        "type": "Science",
        "value": [
          "Astronomy"
        ]
      },
      {
        "type": "Others",
        "value": [
          "Nano-linguistics"
        ]
      }
    ],
    "categories": [
      "Study Tips",
      "Music",
      "Habits & Routines"
    ],
    "isOnline": true,
    "lastOnlineAt": "2025-08-01T05:32:07.075Z",
    "isManuallyOffline": true,
    "followers": 500,
    "followings": 200,
    "location": {
      "type": "Point",
      "coordinates": [
        -34.566,
        12.455
      ]
    },
    "locationString": "Central Park, Rock-port, UK",
    "status": {
      "_id": "6899c1bbabe4f0b09ab85a46",
      "user": "688c51572b675be4b88339d1",
      "category": "Open for Anything",
      "schedule": "now",
      "startDateType": "today",
      "startDate": "2025-08-11",
      "startTime": "11:45 PM",
      "title": "Meet me at coffee",
      "startedAt": "2025-08-11T18:15:00.000Z",
      "visibleAt": "2025-08-11T06:15:00.000Z",
      "endedAt": "2025-08-11T19:15:00.000Z",
      "createdAt": "2025-08-11T10:11:07.856Z",
      "updatedAt": "2025-08-11T10:11:07.856Z"
    }
  }
}
```

# 🔒 GET `/users/:id`

## Description

- Returns the details of that specific user
- This also works for current user
- Also return chatId if any one-to-one chat exist between this user and current user
- Handle user blocking case

## Response Body

```json
{
  "user": {
    "_id": "688c51572b675be4b88339d1",
    "email": "john.doe@example.com",
    "dob": "1997-01-23T00:00:00.000Z",
    "auth": {
      "emailVerified": true,
      "phoneVerified": false
    },
    "verified": true,
    "createdAt": "2025-08-01T05:32:07.075Z",
    "updatedAt": "2025-08-11T10:11:08.160Z",
    "purposes": [
      {
        "type": "short-term",
        "value": [
          "Improve mental wellness",
          "Grow meaningful relationships"
        ]
      },
      {
        "type": "long-term",
        "value": [
          "Improve mental wellness",
          "Enhance academic success"
        ]
      }
    ],
    "name": "John Doe",
    "phone": "+1 1234567899",
    "username": "john.doe",
    "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
    "studies": [
      {
        "type": "Engineering",
        "value": [
          "Mechanical Engineering",
          "Robotics Engineering"
        ]
      },
      {
        "type": "Business & Management",
        "value": [
          "Financial Accounting",
          "Marketing 101"
        ]
      },
      {
        "type": "Science",
        "value": [
          "Astronomy"
        ]
      },
      {
        "type": "Others",
        "value": [
          "Nanolinguistics"
        ]
      }
    ],
    "categories": [
      "Study Tips",
      "Music",
      "Habits & Routines"
    ],
    "bio": "I am a workaholic",
    "courses": "Algorithms, Designs, Robotics, Ethics",
    "url": "https://instagram.com/john.doe",
    "school": "Mechanical Engineering, Robotics Engineering, Financial Accounting, Marketing 101, Astronomy, Nanolinguistics",
    "followers": 0,
    "followings": 0
  },
  "isFollower": false,
  "isFollowing": false,
  "location": {
    "type": "Point",
    "coordinates": [
      -34.566,
      12.455
    ]
  },
  "locationString": "Central Park, Rock-port, UK",
  "status": {
    "_id": "6899c1bbabe4f0b09ab85a46",
    "user": "688c51572b675be4b88339d1",
    "category": "Open for Anything",
    "schedule": "now",
    "startDateType": "today",
    "startDate": "2025-08-11",
    "startTime": "11:45 PM",
    "title": "Meet me at coffee",
    "startedAt": "2025-08-11T18:15:00.000Z",
    "visibleAt": "2025-08-11T06:15:00.000Z",
    "endedAt": "2025-08-11T19:15:00.000Z",
    "createdAt": "2025-08-11T10:11:07.856Z",
    "updatedAt": "2025-08-11T10:11:07.856Z"
  },
  "connection": {
    "_id": "689a26c16cbaee0c43c7baed",
    "from": {
      "_id": "688c51572b675be4b88339d1",
      "name": "John Doe",
      "username": "john.doe",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
      "bio": "I am a workaholic"
    },
    "to": {
      "_id": "68914287e4c3076d9436523c",
      "bio": "I am a song lover",
      "name": "Amy Jackson",
      "username": "amy.jackson"
    },
    "status": "accepted",
    "createdAt": "2025-08-11T17:22:09.000Z",
    "acceptedAt": "2025-08-11T17:32:35.784Z"
  },
  "chatId": "68bee79857ab80b69867946b"
}
```

# 🔒 POST `/users/check-username`

## Description

- Checks if username is available
- Returns `409`, if not available
- Returns `200`, if available
- username must follow this Regex:

```js
/^[^\W_](?!.*?[._]{2})[\w.]{6,18}[^\W_]$/
```

## Request Body

```js
{
  username: 'john.doe'
}
```

# 🔒 PATCH `/users`

## Description

- Changes user data
- All fields are optional
- While updating `username`, also check if its available
- If `phone` is given, reset all phone otp related fields
- If `password` is given, then `oldPassword` is also required
- `type` field in `purposes` has only 2 possible values: `short-term` and `long-term`
- If `url` field is specifically given `null`, then it will delete the `url` field

## Request Body

```json
{
  "name?": "John Doe",
  "bio?": "I am a workaholic",
  "url?": "https://instagram.com/john.doe" | null,         // null will delete the url field
  "school?": "Computer Science & Human Centered Design",
  "courses?": "Algorithms, Designs, Robotics, Ethics",
  "dob?": "1997-01-23",
  "phone?": "+1 1234567899",
  "username?": "jane.smith",
  "twoFactorAuthentication?": true,
  "password?": "12345678",
  "oldPassword?": "12345678",
  "purposes?": [
    {
      "type": "short-term",
      "value": ["Improve mental wellness", "Grow meaningful relationships"]
    },
    {
      "type": "long-term",
      "value": ["Improve mental wellness", "Enhance academic success"]
    }
  ],
  "studies?": [
    {
      "type": "Engineering",
      "value": ["Mechanical Engineering", "Robotics Engineering"]
    },
    {
      "type": "Business & Management",
      "value": ["Financial Accounting", "Marketing 101"]
    },
    {
      "type": "Science",
      "value": ["Astronomy"]
    },
    {
      "type": "Others",
      "value": ["Nanolinguistics"]
    }
  ],
  "categories?": ["Study Tips", "Music", "Habits & Routines"],
  "isManuallyOffline?": true,
  "platform?": "android/ios/web",
  "fcmToken?": "token_1234567890abcdefABCDEF1234567890abcdefABCDEF-xyz1234567890_ABCD1234567890abcdef",
  "latitude?": 12.455,
  "longitude?": -34.566,
  "locationString?": "Central Park, Rock-port, UK",
}
```


# 🔒 PUT `/users/photo`

## Description

- Changes user photo
- Delete previous photo if exist
- Returns the url on successful upload

## Request Body (form-data)

```js
{
  photo: File
}
```

## Response Body

```js
{
  photo: string
}
```

# 🔒 DELETE `/users/me`

## Description

- Disables the account
- Account schedules to be deleted after 7 days
- Send email notification also
- Soft delete the user data through cron jobs after 7 days
- In cron job, Remove all the user fields and put it into its `data` field

# Links

[Goto Home](/docs/index.html)