import { Schema, model, Document, Types } from 'mongoose'

const ViewSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		reel: {
			type: Types.ObjectId,
      ref: 'Reel',
			required: true,
		},
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface IView extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	reel: Types.ObjectId
	at: Date
}

export const View = model('View', ViewSchema, 'views')
