import fs from 'fs'
import path from 'path'

const srcDir = './src'
const distDir = './dist/src'

const extensions = ['.md']

function copyFilesWithExtensions(src: string, dest: string) {
  if (!fs.existsSync(dest)) fs.mkdirSync(dest, { recursive: true })

  for (const file of fs.readdirSync(src)) {
    const srcPath = path.join(src, file)
    const destPath = path.join(dest, file)
    const stat = fs.statSync(srcPath)

    if (stat.isDirectory()) {
      copyFilesWithExtensions(srcPath, destPath)
    } else {
      const ext = path.extname(file)
      if (extensions.includes(ext)) {
        fs.copyFileSync(srcPath, destPath)
      }
    }
  }
}

copyFilesWithExtensions(srcDir, distDir)
