import { Connection } from 'mongoose'
import firebaseAdmin from 'firebase-admin'
import cron from './cron'
import colors from 'colors'
import { ISocket, ISocketServer, ScheduleEvent, ScheduleEventHandler, SocketEvent, SocketEventHandler } from './types'
import config from './config'

const constants = {
	db: undefined as unknown as Connection,
	io: undefined as unknown as ISocketServer,
	sockets: {} as Record<string, ISocket[] | undefined>,
	socketHandlers: {} as Record<SocketEvent, SocketEventHandler>,
	firebaseAdmin: undefined as (typeof firebaseAdmin | undefined),
	cron: undefined as (typeof cron | undefined),
	colors: undefined as (typeof colors | undefined),
	locationMode: true,
	locationDistance: 25_000, // in meters (25km radius)
	earthRadius: 6_378_137,  // in meters
	emailOtpExpiry: 5, // in mins
	phoneOtpExpiry: 5, // in mins
	minEmailOtpResendDelay: 30, // in sec
	minPhoneOtpResendDelay: 30, // in sec
	phoneRegex: 'regex:/^\\+\\d{1,3} \\d{6,14}$/',
	usernameRegex: 'regex:/^[^\\W_](?!.*?[._]{2})[\\w.]{1,20}[^\\W_]$/',
	socketRegex: 'regex:/^[A-Za-z0-9\\-_]{16,25}$/',
	maxLoggedinDevices: config.isProduction ? 4 : 10,
	days: ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'] as const,
	notificationEvents: [
		'comment-created',
		'comment-updated',
		'connection-request',
		'connection-accepted',
		'user-followed',
		'reel-liked',
		'comment-liked',
		'reel-shared',
		'reel-super-liked',
		'message-received',
		'message-sent',
		'group-chat-created',
		'chat-join-request',
		'chat-request-accepted',
		'chat-admin-access-granted',
		'chat-admin-access-removed',
		'chat-access-removed',
		'chat-joined',
		'event-access-granted',
		'event-access-rejected',
		'event-joined',
		'reward-unlocked',
	] as const,
	socialConnectednessActions: [
		{
			type: 'open-view-all-rewards',
			label: 'Click on View All in the Rewards Near Me',
			subLabel: 'Encourage real-world explorations with your surroundings',
			days: ['monday']
		},
		{
			type: 'create-meetme-status',
			label: 'Add a "Meet Me" Status',
			subLabel: 'Show you\'re open to new connections',
			days: ['monday', 'sunday']
		},
		{
			type: 'add-new-friend',
			label: 'Add one new friend',
			subLabel: 'Expand your circle with presence — connection begins with mindful curiosity',
			days: ['tuesday']
		},
		{
			type: 'create-super-like',
			label: 'Super-like a Vibe video in the home feed',
			subLabel: 'Pause to notice what truly inspires you and express appreciation with intention to the creator',
			days: ['tuesday', 'thursday']
		},
		{
			type: 'create-meetme-request',
			label: 'Send a "Meet Me" request to someone new',
			subLabel: 'Step outside your comfort zone and open space for genuine connection',
			days: ['wednesday']
		},
		{
			type: 'open-view-all-events',
			label: 'Click on View All in the Events Near Me',
			subLabel: 'Discover new experiences and build meaningful connections offline',
			days: ['wednesday']
		},
		{
			type: 'join-group-chat',
			label: 'Join a new community in the Explore page',
			subLabel: 'Expand your perspective, nurture belonging, and deepen meaningful connection',
			days: ['thursday']
		},
		{
			type: 'watch-vibe-dynamic',
			label: 'Watch a Vibe Dynamic video',
			subLabel: 'Engage your mind and interact with creative Vibes',
			days: ['friday']
		},
		{
			type: 'search-with-meetme-category-filter',
			label: 'Filter Meet Me requests by category (e.g., "Coffee")',
			subLabel: 'Align connections with your interests, reduce overwhelm, and support mindful, safe meetups',
			days: ['friday']
		},
		{
			type: 'mindful-comment-reply',
			label: 'Reply mindfully to a comment in the home feed',
			subLabel: 'Cultivate empathy by responding with kindness and understanding different perspectives',
			days: ['saturday']
		},
		{
			type: 'send-dm-message',
			label: 'Send a DM to a friend',
			subLabel: 'Strengthen real connection and presence through one-to-one mindful conversation',
			days: ['saturday']
		},
		{
			type: 'mindful-comments',
			label: 'Leave 3 mindful comments',
			subLabel: 'Practice mindful comments — each word can uplift someone\'s day, including yours',
			days: ['sunday'],
			count: 0,
		}
	] as const,
	mindfulnessActions: [
		{ type: 'focus-video', label: 'Watch a Focus video (1 min)', startAt: 8 },
		{ type: 'mindfulness-video', label: 'Watch a Mindfulness video (1 min)', startAt: 15 },
		{ type: 'reflection-video', label: 'Watch a Reflection video (1 min)', startAt: 20 },
		{ type: 'journalism', label: 'Write in Your Journal', startAt: 20 },
	] as const,
	collections: ['users', 'reels'] as const,
	reelsInCompression: {} as Record<string, boolean>,
	scheduleHandlers: {} as Record<ScheduleEvent, ScheduleEventHandler>,
	compressionProcessingCount: 0,
	maxCompressionQueueSize: 100,
	compressionEnabled: false,
	maxOnlineVisibilityInMinutes: 15, // 15 min
}

export default constants
