import cron from 'node-cron'
import helpers from './helpers'
import services from './services'
import constants from './constants'

// delete old files every hour
cron.schedule('0 * * * *', async () => {
	helpers.deleteOldFiles()
})

// removes all unverified users (created 7 days ago), runs every Monday at midnight
cron.schedule('0 0 * * 1', async () => {
  services.deleteOldUnverifiedUsers()
})

// removes all notifications older than 7 days, run at every sunday midnight
cron.schedule('0 0 * * 0', async () => {
	services.deleteOldNotifications()
})

// Soft delete all deactivated users older than 7 days, run every night 1AM
cron.schedule('0 1 * * *', async () => {
	services.deleteDeactivatedUsers()
})

// Runs reels compression every hour
if(constants.compressionEnabled) {
	cron.schedule('7 * * * *', async () => {
		services.addUncompressedReelsToQueue()
	})
}

export default cron
